#ifndef __MADC_BH704_H
#define __MADC_BH704_H

#include <cstdint>

#include "..\GPIO\MGPIO.h"

/*########################################################################################*/
/******************** KLASY ***************************************************************/      

// ADC_1.ch11  IA
// ADC_1.ch12  IB
// ADC_2.ch2   UA
// ADC_2.ch14  UB







  class MADC{

    //+++ POLA ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	public: uint16_t mADC1_Tab[11];  // [0]=IA; [1]=IB

    //public: uint8_t gADC_State = 5;
    
    //public: uint8_t mCurADC2_Channel;
    //public: uint8_t mCurADC1_Channel;
  
  //  public: __IO int16_t adcValuePREV[6] = {-1,-1,-1,-1,-1,-1};
  //  public: __IO int16_t adcValue[6] = {-1,-1,-1,-1,-1,-1};

	public: uint8_t mIsS0ON = 0;
	public: uint8_t mIsS1ON = 0;
	public: uint8_t mWasS0Short = 0;
	public: uint8_t mWasS1Short = 0;
	public: uint8_t mWasS0Latched = 0;
	public: uint8_t mWasS1Latched = 0;
	public: uint8_t mWasS0TurnedOff = 0;
	public: uint8_t mWasS1TurnedOff = 0;
	public: uint8_t mWasS0MaskSset = 0;
	public: uint8_t mWasS1MaskSset = 0;

	// Do wyłączania izolatora w przypadku zaniku zasilania.
	public: bool	 mIs0V = false;						// Flaga, czy jest obecnie spadek zasilania.
	public: uint32_t mTimeFrom0V_ms = 0;				// Licznik ile ms minęło od zaniku zasilania.
	public: uint32_t mTimeFrom0VLimit_ms = 20;			// Limit do którego ma odliczać przed wyłączeniem.
	public: uint32_t mTimeForStablize0V_ms = 0;			// Licznik ile ms minęło od ustabiliziowania zasilania po jego zaniku.
	public: uint32_t mTimeForStabilize0VLimit_ms = 5;	// Limit do którego ma odliczać przed stwierdzeniem, że jednak nie ma zaniku zasilania.

    public: int16_t mS0 = 0;
    public: int32_t mS0_iir = 2000*2048;
    public: int16_t mS0_avr = 2000;
    public: int16_t mS1 = 0;
    public: int32_t mS1_iir = 2000*2048;
    public: int16_t mS1_avr = 2000;
    
    public: int16_t mUA = 0;    
    public: int32_t mUA_iir = 2000*8192;
    public: int16_t mUA_avr = 2000;

    
    public: int16_t mIA = 0;
    public: int32_t mIA_iir = 2000*2048;
    public: int16_t mIA_avr = 2000;
    public: int32_t mIAabs_iir = 0;
    public: int16_t mIAabs_avr = 0;
    
    
    public: int16_t mUB = 0;
    public: int32_t mUB_iir = 2000*8192;
    public: int16_t mUB_avr = 2000;

    
    public: int16_t mIB = 0;
    public: int32_t mIB_iir = 2000*2048;
    public: int16_t mIB_avr = 2000;
    public: int32_t mIBabs_iir = 0;
    public: int16_t mIBabs_avr = 0;
    
    public: int16_t mVRef = 0;

    
    //public: __IO int32_t adcValueAvr[6] = {-1,-1,-1,-1,-1,-1};

//    public: int32_t diffsAVR[6] = {-1,-1,-1,-1,-1,-1};
 //   public: int32_t diffs[6] = {-1,-1,-1,-1,-1,-1};
  

  
    //+++ METODY +++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    public: void initIRQ(); 
    public: void  onSample_ADC1();
    public: void  onSample_ADC2();
    public: void turnOnS0(bool resetValues);
    public: void turnOnS1(bool resetValues);
    public: void turnOffS0();
    public: void turnOffS1();
    

    //+++ STARE ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /// inicjalizacja
    public: void init();  // stare

    /// event: TIMER    
    public: void onTimer(); // puste
    public: void onTimer_1ms();
    
    
    };//************************************************************************************



    MADC gADC;


/*########################################################################################*/
/******************** METODY **************************************************************/      






#endif
/*########################################################################################*/
