#ifndef __MADC_BH704_CPP_H
#define __MADC_BH704_CPP_H

#include "MADC.h"

/*########################################################################################*/

//-----------------------------------------------------------------------------
void MADC::init(){
	  mWasS0Latched = 0;
	  mWasS1Latched = 0;
	  mWasS0Short = 0;
	  mWasS1Short = 0;

	  mTimeForStablize0V_ms = 0;
	  mTimeFrom0V_ms = 0;

	  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 1 );	// sensor ON
	  mIsS0ON = 1;

	  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 1 );	// sensor ON
	  mIsS1ON = 1;

	  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, (GPIO_PinState) 0 ); // onCM_ON - zalacznie pomiaru pradu

}//----------------------------------------------------------------------------


  
//-----------------------------------------------------------------------------
  /// wywolywane po   __enable_irq();
void MADC::initIRQ(){
	  HAL_ADC_Start_DMA( &hadc1, (uint32_t*)mADC1_Tab, 10 );
}//----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
void  MADC::onTimer( ){
  


}//----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
uint32_t gVrefint_raw = 0;
uint32_t gMeasurement_raw = 0;
uint32_t gVdda_voltage = 0;
uint32_t gMeasurement_voltage = 0;

void MADC::onTimer_1ms(){

	// Czy jest zanik zasilania?
	if (mIs0V)
	{
		// Doliczaj ms, żeby wiedzieć ile już nie ma zasilania.
		mTimeFrom0V_ms++;

		// Brak zasilania = zresetuj liczniki stabilizacji.
		mTimeForStablize0V_ms = 0;
	}
	else
	{
		// Jeżeli sytuacja jest stabilna przez X ms, nie ma zaniku zasilania.
		if (mTimeForStablize0V_ms >= mTimeForStabilize0VLimit_ms)
		{
			mTimeFrom0V_ms = 0;
		}
		else
		{
			// Nie wiadomo czy jest stabilnie, zwiększaj licznik normalnie.
			mTimeFrom0V_ms++;
			mTimeForStablize0V_ms++;
		}
	}


	// Jeśli minął limit czasu działania bez zasilania - wyłącz przekaźniki. Lub spadło napięcie REF na procesorze - wtedy jest już źle i możemy nie zdążyć nawet wyłączyć.
	if ((mTimeFrom0V_ms > mTimeFrom0VLimit_ms) || ((gVdda_voltage < 2800) && (gVrefint_raw > 0)))
	{
		gSystem.mIsTurningOff = true;

		_oREL_A_SET = 0;
		_oREL_B_SET = 0;

		_oREL_A_RESET = 1;
		_oREL_B_RESET = 1;

		// Oznacz w zmiennych, w razie gdyby po RS jeszcze zdążył odpowiedzieć.
		gRelays.mRelA_IsON = false;
		gRelays.mRelB_IsON = false;

		for (volatile int i = 0; i < 10000000; i++);

		_oREL_A_RESET = 0;
		_oREL_B_RESET = 0;

		// 09.04.2024, druga pętla została wyrzucona, żeby izolator szybciej się zrestartował i działał,
		// jeśli zasilania nie było na tyle długo, że się wyłączył, ale jednocześnie szybko wróciło i chcemy pracować dalej
		// np. KG chciało zresetować linię
		//for (volatile int i = 0; i < 10000000; i++);

		__NVIC_SystemReset();
	}
}//----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
void  MADC::onSample_ADC1(){


	// mADC1_Tab[0] - channel 5    - aV_SMPS_VIN
	// mADC1_Tab[1] - channel 6    - aV_12V
	// mADC1_Tab[2] - channel 9    - aVBRA
	// mADC1_Tab[3] - channel 10   - aCurHOT
	// mADC1_Tab[4] - channel 11   - aCurCOLD
	// mADC1_Tab[5] - channel 12   - aSens_swSens2
	// mADC1_Tab[6] - channel 15   - aSens_swSens1
	// mADC1_Tab[7] - channel 16   - aVBRB
	// mADC1_Tab[8] - channel Vbat - Vbat
	// mADC1_Tab[9] - channel Vrefint - napięcie referenycjne



	mUA = mADC1_Tab[2]; // UA
	mUB = mADC1_Tab[7]; // UB

	mIA = mADC1_Tab[3]; // aCurHOT
	mIB = mADC1_Tab[4]; // aCurCOLD

	mVRef = mADC1_Tab[9];	// Napięcie referencyjne.

	if (mIsS1ON)
		mS1 = mADC1_Tab[5]; // aSens_swSens2

	if (mIsS0ON)
		mS0 = mADC1_Tab[6]; // aSens_swSens1

	// BRAK
	// mADC1_Tab[0] - channel 5    - aV_SMPS_VIN
	// mADC1_Tab[1] - channel 6    - aV_12V
	// mADC1_Tab[8] - channel Vbat - Vbat

	// ... IA .......................
	{
	  mIA_iir += mIA;
	  mIA_avr = mIA_iir / 2048;
	  mIA_iir -= mIA_avr; //adcValueAvr[1] / 2048;


	  int16_t abs = ( mIA - mIA_avr );
	  if( abs < 0 ) abs =  - abs;

	  gADC.mIAabs_iir += abs;
	  mIAabs_avr = gADC.mIAabs_iir / 64;
	  gADC.mIAabs_iir -= mIAabs_avr;
	}

	// ... IB .......................
	{
	  mIB_iir += mIB;
	  mIB_avr = mIB_iir / 2048;
	  mIB_iir -= mIB_avr; //adcValueAvr[1] / 2048;

	  int16_t abs = ( mIB - mIB_avr );
	  if( abs < 0 ) abs =  - abs;

	  gADC.mIBabs_iir += abs;
	  mIBabs_avr = gADC.mIBabs_iir / 64;
	  gADC.mIBabs_iir -= mIBabs_avr;
	}

	// ... UA .......................
	{
	   mUA_iir += mUA;
	   int32_t avrA = mUA_iir / 8192;	// 30.04.2034 Zwiększyłem filtr z 512 do 8192, bo szpilka od puknięcia w mikrofon wyłączała izolator.
	   	   	   	   	   	   	   			// Filtr 16k powoduje, że przy zwarciu na głośniku przy pilocie, inne izolatory się nie wyłączają i zwierany się w kółko resetuje. Są zbyt nieczułe.
	   mUA_iir -= avrA; //adcValueAvr[1] / 2048;

	   mUA_avr = avrA;
	}

	// ... UB .......................
	{
	   mUB_iir += mUB;
	   int32_t avrB = mUB_iir / 8192;  // 30.04.2034 Zwiększyłem filtr z 512 do 8192, bo szpilka od puknięcia w mikrofon wyłączała izolator.
	   	   	   	   	   	   	   	   	   // Filtr 16k powoduje, że przy zwarciu na głośniku przy pilocie, inne izolatory się nie wyłączają i zwierany się w kółko resetuje. Są zbyt nieczułe.
	   mUB_iir -= avrB; //adcValueAvr[1] / 2048;

	   mUB_avr = avrB;
	}

	// ... IS0 .......................
	{
		mS0_iir += mS0;
		mS0_avr = mS0_iir / 8192;		// Duży filtr, żebyśmy mogli odróżnić zwarcie od aktywacji czujek.
		mS0_iir -= mS0_avr;
	}

	// ... IS1 .......................
	{
		mS1_iir += mS1;
		mS1_avr = mS1_iir / 8192;		// Duży filtr, żebyśmy mogli odróżnić zwarcie od aktywacji czujek.
		mS1_iir -= mS1_avr;
	}




	// Tutaj obliczanie napięcia na przekaźniku po uwzględnieniu vref.
	// Nie korzystamy z gMeasurement_voltage bo i tak jest za późno na wyłączanie przekaźników, kiedy mamy zafałoszowane wartości na mUA_avr.
	// Ale zostawiam obliczanie vdda, jako ostatnią furtkę do wyłączenia przekaźników w procedurze umierania.
	if (mVRef > 0)
	{
		gVrefint_raw = mVRef;
		gMeasurement_raw = mUA_avr;//mUA;//mUA_avr
		gVdda_voltage = __HAL_ADC_CALC_VREFANALOG_VOLTAGE(gVrefint_raw, ADC_RESOLUTION_12B);
		// gMeasurement_voltage = __HAL_ADC_CALC_DATA_TO_VOLTAGE(gVdda_voltage, gMeasurement_raw, ADC_RESOLUTION_12B);
	}




	// Wyłączenie przekaźników po odcięciu zasilania - rozpocznij odliczanie.
#ifdef _AC
	if ((mUB_avr < 350) && (mUA_avr < 350))	// Jeżeli spadło napięcie.
#else
	if ((mUB_avr < 1200) && (mUA_avr < 1200))	// Dobre dla samego DC i DC+Pilot
#endif
		mIs0V = true;
	else
		mIs0V = false;


	// Wyłączenie pinów od czujek po wykryciu zwarcia.
	{
		if ((mS0 > 3000) && (!mWasS0Latched))	// Kiedy większe niż 3000, ale nie było zalatchowania.
		{
			if (mIsS0ON)
			{
				HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 0);	// Wyłącz pin czujek.
				mIsS0ON = 0;
				mWasS0Short = 1;
			}

			// Zostaw dużą wartość w zmiennej, żeby wysyłać do KG, że było tam zwarcie.
			mS0 = 4000;	// >> 4 = 250
		}

		// To samo dla drugiej czujki.
		if ((mS1 > 3000) && (!mWasS1Latched))
		{
			if (mIsS1ON)
			{
				HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 0);
				mIsS1ON = 0;
				mWasS1Short = 1;
			}

			mS1 = 4000;	// >> 4 = 250
		}
	}


	// Wyłączenie pinów od czujek po wykryciu zbyt dużego prądu.
	{
		if ((mS0_avr > 1300) && (!mWasS0Short))	// Trzykrotność wartości z rezystora 1K (i różne od zwarcia).
		{
			if (mIsS0ON)
			{
				HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 0);	// Wyłącz pin czujek.
				mIsS0ON = 0;
				mWasS0Latched = 1;
			}

			// Zostaw dużą wartość w zmiennej, żeby wysyłać do KG, że był tam alarm.
			mS0 = 1600;	// >> 4 = 100
		}

		// To samo dla drugiej czujki.
		if ((mS1_avr > 1300)  && (!mWasS1Short))
		{
			if (mIsS1ON)
			{
				HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 0);
				mIsS1ON = 0;
				mWasS1Latched = 1;
			}

			mS1 = 1600;	// >> 4 = 100
		}
	}

}//----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
void  MADC::onSample_ADC2()
{


//
//      mUA = gADC2_Tab[0]; // UA
//      mUB = gADC2_Tab[1]; // UB
//      mS0 = gADC2_Tab[2]; // USense
//
//
//      // ... UA .......................
//      mUA_iir += mUA;
//      int16_t avrA = mUA_iir / 512;
//      mUA_iir -= avrA; //adcValueAvr[1] / 2048;
//
//      mUA_avr = avrA;
//
//     // ... UB .......................
//      mUB_iir += mUB;
//      int16_t avrB = mUB_iir / 512;
//      mUB_iir -= avrB; //adcValueAvr[1] / 2048;
//
//      mUB_avr = avrB;
//
//
////      int16_t abs = (mUA-avr);
////      if( abs < 0 ) abs =  - abs;
//
//
////      gADC.adcValueAvr[2] += abs;
////      int16_t avr2 = gADC.adcValueAvr[2] / 512;
////      gADC.adcValueAvr[2] -= avr2; //adcValueAvr[1] / 2048;
//
//
//      // ITM_EVENT16( 1, gADC.adcValue[1] );
//
//
//  	// Wyłączenie przekaźników po odcięciu zasilania - najpierw ten z którego się nie zasilamy.
//  	if ((mUB_avr < 10) && (mUA_avr < 10))
//  	{
//  		_oREL_A_RESET = 1;
//  		_oREL_B_RESET = 1;
//
//  		for (volatile int i = 0; i < 10000000; i++);
//
//  		_oREL_A_RESET = 0;
//  		_oREL_B_RESET = 0;
//
//  		for (volatile int i = 0; i < 10000000; i++);
//
//  		__NVIC_SystemReset();
//  	}

	   /*
	    // gADC.adcValue[1] = gADC1_Tab[0]; // UA
	     gADC.adcValue[1] = Joystick2[1]; // UB
	     //gADC.adcValue[1] = Joystick2[1]; // UB

	      gADC.adcValueAvr[1] += gADC.adcValue[1];
	      int16_t avr = gADC.adcValueAvr[1] / 2048;
	      gADC.adcValueAvr[1] -= avr; //adcValueAvr[1] / 2048;

	      // ITM_EVENT16( 1, gADC.adcValue[1] );
	      */



}//----------------------------------------------------------------------------

void MADC::turnOnS0(bool resetValues)
{
	mWasS0Latched = 0;
	mWasS0Short = 0;
	mWasS0TurnedOff = 0;

	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 1 );	// sensor ON
	mIsS0ON = 1;

	if (resetValues)
	{
		// Popraw wartości ADC, aby od nowa sprawdzić sytuację na czujkach.
		mS0 = 0;
		mS0_iir = 2000*2048;
		mS0_avr = 2000;
	}
}

void MADC::turnOnS1(bool resetValues)
{
	mWasS1Latched = 0;
	mWasS1Short = 0;
	mWasS1TurnedOff = 0;

	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 1 );	// sensor ON
	mIsS1ON = 1;

	if (resetValues)
	{
		// Popraw wartości ADC, aby od nowa sprawdzić sytuację na czujkach.
		mS1 = 0;
		mS1_iir = 2000*2048;
		mS1_avr = 2000;
	}
}

void MADC::turnOffS0()
{
	mIsS0ON = 0;
	mWasS0TurnedOff = 1;
	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 0 );	// Sensor OFF.
}

void MADC::turnOffS1()
{
	mIsS1ON = 0;
	mWasS1TurnedOff = 1;
	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 0 );	// Sensor OFF.
}



#endif
/*########################################################################################*/
