#ifndef __MDebug_BH704_CPP_H
#define __MDebug_BH704_CPP_H

void MDebug::init()
{
	CoreDebug->DEMCR |= CoreDebug_DEMCR_TRCENA_Msk;
	DWT->CYCCNT = 0;
	DWT->CTRL |= DWT_CTRL_CYCCNTENA_Msk;

	mWasInit = true;
}

void MDebug::reset()
{
	for(int i=0; i<_MDebug_ChNbr; i++)
		mIndex[i] = 0;
}

void MDebug::recEvent(int ch, uint32_t param, uint32_t value)
{
	if (!mWasInit) return;
	if( ch >= _MDebug_ChNbr ) return;

	int index = mIndex[ch];
	if( index >= _MDebug_TabSize )
		return;

	if (value == 0)
		mTab_Time[ch][index] = DWT->CYCCNT;
	else
		mTab_Time[ch][index] = value;

	mTab_Param[ch][index] = param;
	mIndex[ch] += 1;
}

uint32_t MDebug::getTime()
{
	return DWT->CYCCNT;
}

#endif
