/*
 * MPowerSaving.h
 *
 *  Created on: Jan 29, 2024
 *      Author: Qrystian
 */

#ifndef MODS_POWERSAVING_MPOWERSAVING_H_
#define MODS_POWERSAVING_MPOWERSAVING_H_



class MPowerSaving
{
	// ---------- STAŁE ---------- //

	// --------------------------- //



	// -------- STRUKTURY -------- //
	// --------------------------- //


	// ---------- POLA ---------- //
private:
	uint32_t 	mModemSleepLimit = 0;		// Limit czasu, po którym modem ma zostać włączony (ms).
	uint32_t 	mModemSleepCnt = 0;			// Licznik czasu do włączenia modemu (ms).
	bool 		mModemStatus = false;		// Czy modem jest włączony.
	bool 		mModemIsToTurnOff = false;	// Czy mamy wyłączyć modem po następnej ramce.
	bool		mInitNeeded = false;		// Czy trzeba wykonać init modemu.
public:

	// -------------------------- //



	// ---------- METODY ---------- //
private:

public:
	void init();							// Włącza modem.
	void onTimer_1ms();						// Sprawdza czy trzeba włączyć modem.
	void onMain_0ms();						// Uruchamia inicjalizację modemu po jego ponownym włączeniu.

	void setModemLimit(uint8_t bits);		// Ustawia limit czasu wyłączenia modemu, przeliczając go z 8bitów.
	void turnOnModem();						// Włącza modem.
	void turnOffModemFlag();				// Oznacza flagę, że będziemy chcieli wyłączyć modem.
	void turnOffModemForTime();				// Wyłącza modem, jeśli mamy czas wyłączenia i ktoś ustawił flagę.
	// ---------------------------- //
};



MPowerSaving gPowerSaving;



#endif /* MODS_POWERSAVING_MPOWERSAVING_H_ */
