#ifndef __M485E_RX_CA529_CPP_H
#define __M485E_RX_CA529_CPP_H

#include "M485_E.h"
#include <math.h>

/*########################################################################################*/

/// ----------------------------------------------------------
/// FRAME Reg_Addr  0xBC
void M485E::frameRX_RegAddr(){
  
    uint16_t crc = (uint16_t)((mRXFrameBuf[6] << 8) | (mRXFrameBuf[7]));
    if (crc != 0xE0E1) return;  // nie poprawne CRC
  
    uint8_t gateway = mRXFrameBuf[0];
    uint8_t id_HH   = mRXFrameBuf[1];
    uint8_t id_HL   = mRXFrameBuf[2];
    uint8_t id_LH   = mRXFrameBuf[3];
    uint8_t id_LL   = mRXFrameBuf[4];
    uint8_t newAddr = mRXFrameBuf[5];
    
    // ..........................
    uint32_t id = (uint32_t)( ( id_HH << 24 ) | 
                              ( id_HL << 16 ) | 
                              ( id_LH <<  8 ) | 
                              ( id_LL <<  0 ) );
    
    if( gateway == 0xCC ){
    
      if( id != gSystem.mID ) return; // ID innego urzadzenia
    
      mMyAddr = newAddr;
      sendTX_RegAddr( gateway );
    
    }else{
      
      //if( id == gSystem.mID ) return; // pomylka ID
      if( gateway == mMyAddr )
        gST7580.sendTX_RegAddr( id, newAddr );
      
    }

    
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME ID  0x5B
void M485E::frameRX_ID(){

    uint16_t crc = (uint16_t)((mRXFrameBuf[1] << 8) | (mRXFrameBuf[2]));
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    uint8_t gateway = mRXFrameBuf[0];

    if( gateway == 0xCC ){   // ramka ID do 485
      if( mMyAddr != 0xCC ) return;      // modul zarejestrowany
      sendTX_ID( gateway );
    }else{
      // if( addr == mMyAddr ) return; // blad adresu
      if( gateway == mMyAddr )
        gST7580.sendTX_ID( 0x00 );
    }

}// -----------------------------------------------------------


/// ----------------------------------------------------------
/// FRAME EXT
void M485E::frameRX_Ext(){
 
    uint8_t addr   =  mRXFrameBuf[0];
    uint8_t cnt    =  mRXFrameBuf[1];
    uint8_t *frame = &mRXFrameBuf[2];
  
    uint8_t crcH   =  mRXFrameBuf[3+mRXFrameByteCnt-1];
    uint8_t crcL   =  mRXFrameBuf[4+mRXFrameByteCnt-1];
    
    uint16_t crc = (uint16_t)(( crcH<<8 ) | ( crcL<<0 ));
    if (crc != 0xE0E1) return;  // nie poprawne CRC
        
    // ..........................
    if( mMyAddr != addr ) return;      // modul zarejestrowany
    
    gST7580.mBuf_Frames.bufAddFrame( cnt, frame );
    
}// -----------------------------------------------------------




/// ----------------------------------------------------------
/// FRAME GetID  0x5C // do wywalenia???
void M485E::frameRX_GetID(){
  
    uint16_t crc = (uint16_t)((mRXFrameBuf[2] << 8) | (mRXFrameBuf[3]));
    if (crc != 0xE0E1) return;  // nie poprawne CRC
    
    uint8_t gateway = mRXFrameBuf[0];
    uint8_t addr = mRXFrameBuf[1];
        
    if( gateway == 0xCC ){   // ramka ID do 485
        if( addr != mMyAddr ) return;
        sendTX_GetID( gateway );
    }else{
        // if( addr == mMyAddr ) return; // blad adresu
        if( gateway == mMyAddr )
          gST7580.sendTX_GetID( addr );
    }

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME GetID  0x5C
void M485E::frameRX_ReceiveMsg(){

    uint16_t crc = (uint16_t)((mRXFrameBuf[2] << 8) | (mRXFrameBuf[3]));
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    uint8_t gateway = mRXFrameBuf[0];
    uint8_t addr = mRXFrameBuf[1];

    if( gateway == 0xCC ){   // ramka ID do 485
        if( addr != mMyAddr ) return;
        sendTX_GetID( gateway );
    }else{
        // if( addr == mMyAddr ) return; // blad adresu
        if( gateway == mMyAddr )
          gST7580.sendTX_GetID( addr );
    }

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME getStatus
void M485E::frameRX_getStatus(){

    uint16_t crc = (uint16_t)((mRXFrameBuf[6] << 8) | (mRXFrameBuf[7]));
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    uint8_t loop = mRXFrameBuf[0];
    uint8_t gateway = mRXFrameBuf[1];
    uint8_t addr = mRXFrameBuf[2];
    uint8_t pinMaskValue = mRXFrameBuf[4];
    uint8_t sleepTime = mRXFrameBuf[5];

    if( ( addr == g485E.mMyAddr) && ( gateway == g485E.mMyAddr ) && (loop == g485E.loopNr) ){
    	// ... params ToSend ............
    		gSystem.mIsReg = true;	// Oznacz się jako zarejestrowanego w systemie.

    		// Ustawianie zgodnie z ramką, póki co zakomentowane.
//    		// Ustaw piny czujek.
//			uint8_t s0Mask = 	(pinMaskValue & 1) << 0;
//			uint8_t s0Value = 	(pinMaskValue & 2) << 1;
//			uint8_t s1Mask = 	(pinMaskValue & 4) << 2;
//			uint8_t s1Value = 	(pinMaskValue & 8) << 3;
//
//			if (s0Mask)
//			{
//				gADC.mWasS0MaskSset = 1;
//
//				if ((!gADC.mWasS0Latched) || (!gADC.mWasS0Short))
//				{
//					if (s0Value)
//						gADC.turnOnS0(false);
//					else
//						gADC.turnOffS0();
//				}
//			}
//			else
//				gADC.mWasS0MaskSset = 1;
//
//			if (s1Mask)
//			{
//				gADC.mWasS1MaskSset = 1;
//
//				if ((!gADC.mWasS1Latched) || (!gADC.mWasS1Short))
//				{
//					if (s1Value)
//						gADC.turnOnS1(false);
//					else
//						gADC.turnOffS1();
//				}
//			}
//			else	/// !!! Zrobić reakcję, że jeżeli mamy wyłączyć a było włączone, to niech załączy piny z powrotem.
//				gADC.mWasS1MaskSset = 1;

    	    uint8_t addr   = g485E.mMyAddr;
    	    uint8_t status = 0x01;
    	    if (!gADC.mIsS0ON)
    	    	status |= 0x02;
    	    if (!gADC.mIsS1ON)
    			status |= 0x04;
    	    uint8_t rels2 = 0x00;
    	    if( gRelays.mRelA_IsON ) rels2 |= 0x01;
    	    if( gRelays.mRelB_IsON ) rels2 |= 0x04;

    	    uint8_t prad1 = (gADC.mS0>>4);             // Prad sens 1
    	    uint8_t prad2 = (gADC.mS1>>4);             // Prad sens 2
    	    uint8_t uA_H  = (gADC.mUA_avr>>8);    // UA linii
    	    uint8_t uA_L  = (gADC.mUA_avr>>0);    // UA linii
    	    uint8_t uB_H  = (gADC.mUB_avr>>8);    // UB linii
    	    uint8_t uB_L  = (gADC.mUB_avr>>0);    // UB linii
    	    uint8_t iA_H  = (gADC.mIAabs_avr>>8); // IA linii
    	    uint8_t iA_L  = (gADC.mIAabs_avr>>0); // IA linii
    	    uint8_t iB_H  = (gADC.mIBabs_avr>>8); // IB linii
    	    uint8_t iB_L  = (gADC.mIBabs_avr>>0); // IB linii

    	    this->bufAdd(0x5A);
    	    this->bufAdd(g485E.loopNr); // numberOfLoop
    	    this->bufAdd(addr);	// gateway
    	    this->bufAdd(addr);	// addr
    	    this->bufAdd(0xC3);
    	    this->bufAdd(0x0D);
    	    this->bufAdd( 0xE0 ); // CRC
			this->bufAdd( 0xE1 ); // CRC
    	    this->bufAdd(status);
    	    this->bufAdd(rels2);
    	    this->bufAdd(prad1);
    	    this->bufAdd(prad2);
    	    this->bufAdd(uA_H);
    	    this->bufAdd(uA_L);
    	    this->bufAdd(uB_H);
    	    this->bufAdd(uB_L);
    	    this->bufAdd(iA_H);
    	    this->bufAdd(iA_L);
    	    this->bufAdd(iB_H);
    	    this->bufAdd(iB_L);
    	    this->bufAdd(sleepTime);

			this->Send_IT();

			// Uśpij modem.
			gPowerSaving.setModemLimit(sleepTime);
			gPowerSaving.turnOffModemFlag();
			gPowerSaving.turnOffModemForTime();

    }else{
    	if(gateway == g485E.mMyAddr && loop == g485E.loopNr)
    	{
    		gST7580.sendTX_getStatus(addr, gateway, pinMaskValue, sleepTime);

    		// Nie usypiaj, bo czekamy na odpowiedź.
    	}
    }

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME Unregister
void M485E::frameRX_hiReg(){

    uint16_t crc = (uint16_t)((mRXFrameBuf[4] << 8) | (mRXFrameBuf[5])); // ZMIENIC!
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    uint8_t loop = mRXFrameBuf[0];
    uint8_t gateway = mRXFrameBuf[1];

    // Krańcowy nie odpowiada na HiUnreg, musi być zarejestrowany ustawianiem adresu krańcowym frameRX_setAddrEnd().

    // Stare, zakomentowane:
//    // Jeżeli nie jesteśmy zarejestrowani i zasilamy się z A- odpowiedz.
//    if ((!gSystem.mIsReg) && (gSystem.mPwrSup_Source == EPwrSupSource::A))
//	{
//    	g485E.mMyAddr = 0xCC;
//		sendTX_HiFromUnreg(gateway);
//	}
//    else
    if((gateway == g485E.mMyAddr) && (loop == g485E.loopNr))	// Jeżeli jesteśmy gateway'em - przekaż dalej.
    {
    	gST7580.sendTX_hiUnreg(gateway);
    }
}

// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME Send specific address to all unregistered nodes
void M485E::frameRX_setAddrUnreg(){

    uint16_t crc = (uint16_t)((mRXFrameBuf[2] << 8) | (mRXFrameBuf[3])); // ZMIENIC!
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    uint8_t gateway = mRXFrameBuf[0];
    uint8_t newAddr = mRXFrameBuf[1];

    if(gateway == g485E.mMyAddr)
    {
    	if (!gSystem.mIsReg)	// Jeżeli nie jesteśmy zarejestrowani - zmień adres.
    	{
    		g485E.mMyAddr = newAddr;
			//gFlash_SSD.set8(0, g485E.mMyAddr);
			//gFlash_SSD.flush();
    		gSystem.writeFlash(g485E.mMyAddr);
    	}
    	else					// Jeżeli jesteśmy - przekaż dalej.
    	{

    	}
    }
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME setRelays
void M485E::frameRX_setRelays(){
	uint16_t crc = (uint16_t)((mRXFrameBuf[4] << 8) | (mRXFrameBuf[5]));
	if (crc != 0xE0E1) return;  // nie poprawne CRC

	uint8_t loop = mRXFrameBuf[0];
	uint8_t gateway = mRXFrameBuf[1];
	uint8_t addr = mRXFrameBuf[2];
	uint8_t rel = mRXFrameBuf[6];

	if(( addr == g485E.mMyAddr) && ( gateway == g485E.mMyAddr ) && (loop == g485E.loopNr) )
	{

		gSystem.mPwrSup_Source = EPwrSupSource::NOT_KNOWN;

		bool isRelA = rel & 0x01;
		bool isRelB = rel & 0x04;

		gRelays.setREL_A( isRelA );
		gRelays.setREL_B( isRelB );

		sendTX_RelaysSet(gateway, rel);

    }else{
    	if(gateway == g485E.mMyAddr && loop == g485E.loopNr)
    	{
    		gST7580.sendTX_setRelays(gateway, addr, rel);
    	}
    }

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME setAddr
void M485E::frameRX_setAddr(){

    uint16_t crc = (uint16_t)((mRXFrameBuf[4] << 8) | (mRXFrameBuf[5]));
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    uint8_t loop = mRXFrameBuf[0];
    uint8_t gateway = mRXFrameBuf[1];
    uint8_t addr = mRXFrameBuf[2];
    uint8_t newAddr = mRXFrameBuf[6];

    if(( addr == g485E.mMyAddr) && ( gateway == g485E.mMyAddr ) && (loop == g485E.loopNr)){
    	g485E.mMyAddr = newAddr;
        //gFlash_SSD.set8( 0, g485E.mMyAddr );
        //gFlash_SSD.flush();
    	gSystem.writeFlash(g485E.mMyAddr);

    	// Odpowiedź
    	sendTX_AddressSet(gateway, addr);

    }else{
    	if(gateway == g485E.mMyAddr && loop == g485E.loopNr)
    	{
    		gST7580.sendTX_setAddr(gateway, addr, newAddr);
    	}
    }

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME AskStatus    0xC3
void M485E::frameRX_AskStatus(){ //Czy ta komenda jest do wywalenia?

     uint16_t crc = (uint16_t)((mRXFrameBuf[3] << 8) | (mRXFrameBuf[4]));
     if (crc != 0xE0E1) return;  // nie poprawne CRC
     //mComStats.updateRXFrame_Stats();
  
    uint8_t gateway = mRXFrameBuf[0];
    uint8_t addr = mRXFrameBuf[1];
    int8_t rels = mRXFrameBuf[2];
     

    

    /*uint8_t bitMSBMy = ( mMyAddr & 0x80 );
    uint8_t bitMSBAd = ( addr & 0x80 );
    bool isSendM1 = (bitMSBMy == bitMSBAd);*/
    
//    for( int i =0; i<128; i++ ) gDbgTab[i] = 0;
//    for( int i =0; i<128; i++ ) gDbgTab2[i] = 0;
//    gDbgIndex = 0;
          
    if( gateway == 0xCC ){   // ramka ID do 485
        if( addr != mMyAddr ) return;

        // ... relays ...................
        if( rels & 0x01 ) rels &= ~0x02;
        if( rels & 0x04 ) rels &= ~0x08;        
        if( mPrevRels != rels ){
              gRelays.gRelayCnt = 30;
              gRelays.gShortDeadCnt = 400;
              
                _oREL_A_SET   = ( rels & 0x01 )?1:0;
                _oREL_A_RESET = ( rels & 0x02 )?1:0;
                _oREL_B_SET   = ( rels & 0x04 )?1:0;
                _oREL_B_RESET = ( rels & 0x08 )?1:0;
                
                if( _oREL_A_SET )   gRelays.mRelA_IsON = true;
                if( _oREL_A_RESET ) gRelays.mRelA_IsON = false;
                if( _oREL_B_SET )   gRelays.mRelB_IsON = true;
                if( _oREL_B_RESET ) gRelays.mRelB_IsON = false;

         }
         mPrevRels = rels;
         
        // ... wyslij ramke ............
        sendTX_STATUS( gateway ); // 0x42
              
        
    }else{
        // if( addr == mMyAddr ) return; // blad adresu
        if( gateway == mMyAddr )
          gST7580.sendTX_AskStatus( addr, rels );
    }
 
  
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME CONFIG  0xBF
void M485E::frameRX_Config(){
    uint8_t addr = mRXFrameBuf[0];
    
    if( addr == mMyAddr ){

    }
    
    
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME Unregister
void M485E::frameRX_setUnreg()
{
    uint16_t crc = (uint16_t)((mRXFrameBuf[4] << 8) | (mRXFrameBuf[5])); // ZMIENIC!
    if (crc != 0xE0E1) return;  // nie poprawne CRC

    // Wyrejestruj się z systemu i wyłącz przekaźniki - włączymy ten z którego się zasilamy.
    gSystem.mIsReg = false;
    gRelays.setREL_A(false);
    gRelays.setREL_B(false);
}

// -----------------------------------------------------------

void M485E::frameRX_turnOnPins()
{
	uint16_t crc = (uint16_t)((mRXFrameBuf[4] << 8) | (mRXFrameBuf[5]));
	if (crc != 0xE0E1) return;

	uint8_t loop = mRXFrameBuf[0];
	uint8_t gateway = mRXFrameBuf[1];
	uint8_t addr = mRXFrameBuf[2];

	if ((g485E.loopNr == loop) && (g485E.mMyAddr == gateway) && (g485E.mMyAddr == addr))
	{
		// Wiadomość do nas - ustaw piny i odpowiedz.
//		gADC.turnOnS0(true);
//		gADC.turnOnS1(true);

		// Wiadomość do nas - ustaw piny i odpowiedz.
		gADC.mWasS0Latched = 0;
		gADC.mWasS1Latched = 0;
		gADC.mWasS0Short = 0;
		gADC.mWasS1Short = 0;

		HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 1 );	// sensor ON
		gADC.mIsS0ON = 1;

		HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 1 );	// sensor ON
		gADC.mIsS1ON = 1;

		// Popraw wartości ADC, aby od nowa sprawdzić sytuację na czujkach:
		gADC.mS0 = 0;
		gADC.mS0_iir = 2000*2048;
		gADC.mS0_avr = 2000;
		gADC.mS1 = 0;
		gADC.mS1_iir = 2000*2048;
		gADC.mS1_avr = 2000;

		sendTX_TurnOnPins(gateway, addr);
	}
	else if ((g485E.loopNr == loop) && (g485E.mMyAddr == gateway) && (g485E.mMyAddr != addr))
	{
		// Wiadomość do kogoś innego - przekaż dalej.
		gST7580.sendTX_turnOnPins(gateway, addr);
	}
}

void M485E::frameRX_relayBlock()
{
	uint16_t crc = (uint16_t)((mRXFrameBuf[5] << 8) | (mRXFrameBuf[6]));
	if (crc != 0xE0E1) return;

	uint8_t loop = mRXFrameBuf[0];
	uint8_t gateway = mRXFrameBuf[1];
	uint8_t addr = mRXFrameBuf[2];
	uint8_t rels = mRXFrameBuf[4];

	if ((g485E.loopNr == loop) && (g485E.mMyAddr == gateway) && (g485E.mMyAddr == addr))
	{
		// Wiadomość do nas - zinterpretuj i odeślij odpowiedź.
		gRelays.interpretBlock(rels);
		sendTX_RelayBlock(rels);
	}
	else if ((g485E.loopNr == loop) && (g485E.mMyAddr == gateway) && (g485E.mMyAddr != addr))
	{
		// Wiadomość do kogoś innego - póki co nie przekazujemy.
	}
}

void M485E::frameRX_setAddrEnd()
{
	uint16_t crc = (uint16_t)((mRXFrameBuf[6] << 8) | (mRXFrameBuf[7]));
	if (crc != 0xE0E1) return;

	uint8_t newAddr = mRXFrameBuf[4];
	uint8_t rels = mRXFrameBuf[5];

	// Jeżeli zasilamy się z tego co przyszło w ramce - ustaw adres i odpowiedz.
	if (	((rels == 0x01) && (gSystem.mPwrSup_Source == EPwrSupSource::A))
			||
			((rels == 0x04) && (gSystem.mPwrSup_Source == EPwrSupSource::B)))
	{
		g485E.mMyAddr = newAddr;
		gSystem.writeFlash(g485E.mMyAddr);
		gSystem.mIsReg = true;	// Oznacz się jako zarejestrowanego w systemie.

		// Odpowiedź
		sendTX_setAddrEnd(newAddr, rels);
	}
}

/*########################################################################################*/


#endif
/*########################################################################################*/
