#ifndef __MST7580_BH704_CPP_RX_H
#define __MST7580_BH704_CPP_RX_H

/// ----------------------------------------------------------
/// FRAME ID  ToNode
void MST7580::frameRX_ToNode_ID( uint8_t *frame ){
                 
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME GetID  ToNode
void MST7580::frameRX_ToNode_GetID( uint8_t *frame ){
                 
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME RegAddr  ToNode
void MST7580::frameRX_ToNode_RegAddr( uint8_t *frame ){
  
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME AskStatus  ToNode
void MST7580::frameRX_ToNode_getStatus( uint8_t *frame ){

    // ... params RX ................
    uint8_t fr_addr   	 = frame[1];
    uint8_t fr_gateway   = frame[2];
    uint8_t pinMaskValue = frame[3];
    uint8_t sleepTime 	 = frame[4];

    if( fr_addr != g485E.mMyAddr ) return;

    // Ustawianie zgodnie z ramką - póki co zakomentowane.
//    // Ustaw piny czujek.
//	uint8_t s0Mask = 	(pinMaskValue & 1) << 0;
//	uint8_t s0Value = 	(pinMaskValue & 2) << 1;
//	uint8_t s1Mask = 	(pinMaskValue & 4) << 2;
//	uint8_t s1Value = 	(pinMaskValue & 8) << 3;
//
//	if (s0Mask)
//	{
//		gADC.mWasS0MaskSset = 1;
//
//		if ((!gADC.mWasS0Latched) || (!gADC.mWasS0Short))
//		{
//			if (s0Value)
//				gADC.turnOnS0(false);
//			else
//				gADC.turnOffS0();
//		}
//	}
//	else
//		gADC.mWasS0MaskSset = 0;
//
//	if (s1Mask)
//	{
//		gADC.mWasS1MaskSset = 1;
//
//		if ((!gADC.mWasS1Latched) || (!gADC.mWasS1Short))
//		{
//			if (s1Value)
//				gADC.turnOnS1(false);
//			else
//				gADC.turnOffS1();
//		}
//	}
//	else	/// !!! Zrobić reakcję, że jeżeli mamy wyłączyć a było włączone, to niech załączy piny z powrotem.
//		gADC.mWasS1MaskSset = 0;

    // ... params ToSend ............
    uint8_t addr   = g485E.mMyAddr;
    uint8_t status = 0x01;
    if (!gADC.mIsS0ON)
    	status |= 0x02;
    if (!gADC.mIsS1ON)
		status |= 0x04;

    uint8_t rels2 = 0x00;
    if( gRelays.mRelA_IsON ) rels2 |= 0x01;
    if( gRelays.mRelB_IsON ) rels2 |= 0x04;

    uint8_t prad1 = (gADC.mS0>>4);             // Prad sens 1
    uint8_t prad2 = (gADC.mS1>>4);             // Prad sens 2
    uint8_t uA_H  = (gADC.mUA_avr>>8);    // UA linii
    uint8_t uA_L  = (gADC.mUA_avr>>0);    // UA linii
    uint8_t uB_H  = (gADC.mUB_avr>>8);    // UB linii
    uint8_t uB_L  = (gADC.mUB_avr>>0);    // UB linii
    uint8_t iA_H  = (gADC.mIAabs_avr>>8); // IA linii
    uint8_t iA_L  = (gADC.mIAabs_avr>>0); // IA linii
    uint8_t iB_H  = (gADC.mIBabs_avr>>8); // IA linii
    uint8_t iB_L  = (gADC.mIBabs_avr>>0); // IA linii

//        uint8_t iA_H  = (gADC.mIA_avr>>8); // IA linii
//        uint8_t iA_L  = (gADC.mIA_avr>>0); // IA linii
//        uint8_t iB_H  = (gADC.mIB_avr>>8); // IA linii
//        uint8_t iB_L  = (gADC.mIB_avr>>0); // IA linii

//      uint8_t iA_H  = (gADC.mIA>>8); // IA linii
//      uint8_t iA_L  = (gADC.mIA>>0); // IA linii
//      uint8_t iB_H  = (gADC.mIB>>8); // IB linii
//      uint8_t iB_L  = (gADC.mIB>>0); // IB linii


//    uint8_t iB_H  = (gADC.mIBabs_avr>>8); // IB linii
//    uint8_t iB_L  = (gADC.mIBabs_avr>>0); // IB linii

    gSystem.mIsReg = true;

    // ... send .....................
    uint8_t frameTX[] = {
        0x23,   // RX_Status
		0xC3,	// Type == Status
		fr_gateway,	// odeslij do gateway
        addr,
        status,
        rels2,
        prad1,
        prad2,
        uA_H,
        uA_L,
        uB_H,
        uB_L,
        iA_H,
        iA_L,
        iB_H,
        iB_L,
		sleepTime
    };

    int cnt = sizeof( frameTX );
    gST7580.mBuf_Frames.bufAddFrame( cnt, frameTX );

    // Uśpij modem po wysłaniu obecnej ramki.
    gPowerSaving.setModemLimit(sleepTime);
    gPowerSaving.turnOffModemFlag();

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME AskStatus  ToNode
void MST7580::frameRX_ToNode_setRelays( uint8_t *frame ){

    // ... params RX ................
	uint8_t gateway = frame[1];
    uint8_t addr   = frame[2];
    uint8_t relays = frame[3];

    if( addr != g485E.mMyAddr ) return;

    bool isRelA = relays & 0x01;
	bool isRelB = relays & 0x04;

	gRelays.setREL_A( isRelA );
	gRelays.setREL_B( isRelB );

	// Odpowiedź.
	uint8_t frameTX[] = {
		0x25,   // RX_Relays
		gateway,	// odeslij do gateway
		addr,
		relays,
	};

	int cnt = sizeof( frameTX );
	gST7580.mBuf_Frames.bufAddFrame( cnt, frameTX );

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME AskStatus  ToNode
void MST7580::frameRX_ToNode_setAddr( uint8_t *frame ){

    // ... params RX ................
	uint8_t gateway = frame[1];
    uint8_t addr    = frame[2];
    uint8_t newAddr = frame[3];

    if( addr != g485E.mMyAddr ) return;

    g485E.mMyAddr = newAddr;
//    gFlash_SSD.set8( 0, g485E.mMyAddr );
//    gFlash_SSD.flush();
	gSystem.writeFlash( g485E.mMyAddr );

	// Odpowiedź.
	uint8_t frameTX[] = {
		0x26,   	// RX_SetAddr
		gateway,	// odeslij do gateway
		addr,
		newAddr,
	};

	int cnt = sizeof( frameTX );
	gST7580.mBuf_Frames.bufAddFrame( cnt, frameTX );

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME set specific address to unregistered nodes
void MST7580::frameRX_ToNode_setAddrUnreg( uint8_t *frame ){

    // ... params RX ................
    uint8_t newAddr    = frame[1];

    if( gSystem.mIsReg ) return;

    g485E.mMyAddr = newAddr;
//    gFlash_SSD.set8( 0, g485E.mMyAddr );
//    gFlash_SSD.flush();
	gSystem.writeFlash( g485E.mMyAddr );

    // BRAKUJE POTWIERDZENIA !!!

}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME AskStatus  ToNode
void MST7580::frameRX_ToNode_hiUnreg( uint8_t *frame ){

    // ... params RX ................
    if( gSystem.mIsReg ) return;	// Jeżeli zarejestrowany już - nie odpowiadaj.

    g485E.mMyAddr = 0xCC;
    uint8_t addr =  g485E.mMyAddr;
    uint8_t gateway = frame[1];


    // ... send .....................
        uint8_t frameTX[] = {
            0x24,   // RX_HiReg_Ans
            addr,
			gateway
        };

        int cnt = sizeof( frameTX );
        gST7580.mBuf_Frames.bufAddFrame( cnt, frameTX );


}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME EXT  ToNode
void MST7580::frameRX_ToNode_Ext( uint8_t *frame ){
  
    
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME TurnOnPins  ToNode
void MST7580::frameRX_ToNode_turnOnPins( uint8_t *frame )
{
    // ... params RX ................
	uint8_t gateway = frame[1];
    uint8_t addr   = frame[2];

	// Wiadomość do nas - ustaw piny i odpowiedz.
	gADC.mWasS0Latched = 0;
	gADC.mWasS1Latched = 0;
	gADC.mWasS0Short = 0;
	gADC.mWasS1Short = 0;

	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_11, (GPIO_PinState) 1 );	// sensor ON
	gADC.mIsS0ON = 1;

	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_12, (GPIO_PinState) 1 );	// sensor ON
	gADC.mIsS1ON = 1;

	// Popraw wartości ADC, aby od nowa sprawdzić sytuację na czujkach:
	gADC.mS0 = 0;
	gADC.mS0_iir = 2000*2048;
	gADC.mS0_avr = 2000;
	gADC.mS1 = 0;
	gADC.mS1_iir = 2000*2048;
	gADC.mS1_avr = 2000;

    // Odpowiedź.
	uint8_t frameTX[] = {
		0x27,   	// RX_TurnOnPins
		gateway,	// odeslij do gateway
		addr,
	};

	int cnt = sizeof( frameTX );
	gST7580.mBuf_Frames.bufAddFrame( cnt, frameTX );
}



/// ----------------------------------------------------------
/// FRAME ID  ToGateway 
void MST7580::frameRX_ToGateway_ID( uint8_t *frame ){
                   
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME GetID  ToGateway
void MST7580::frameRX_ToGateway_GetID( uint8_t *frame ){
    
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME RegAddr  ToGateway 

void MST7580::frameRX_ToGateway_RegAddr( uint8_t *frame ){
    
}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME AskStatus  ToGateway
void MST7580::frameRX_ToGateway_getStatus( uint8_t *frame ){
	uint8_t type   = frame[1];
	uint8_t gateway = frame[2];
	uint8_t addr  = frame[3];
	uint8_t status  = frame[4];
	uint8_t rels2  = frame[5];
	uint8_t mSO1   = frame[6];
	uint8_t mSO2   = frame[7];
	uint8_t mUA1   = frame[8];
	uint8_t mUA2   = frame[9];
	uint8_t mUB1   = frame[10];
	uint8_t mUB2   = frame[11];
	uint8_t mIA1   = frame[12];
	uint8_t mIA2   = frame[13];
	uint8_t mIB1   = frame[14];
	uint8_t mIB2   = frame[15];
	uint8_t sleepTime = frame[16];

	if(g485E.mMyAddr != gateway) return;

    g485E.bufAdd( 0x5A );     // naglowek


    g485E.bufAdd( g485E.loopNr ); // loop number
    g485E.bufAdd( gateway );  // gateway
    g485E.bufAdd( addr );     // address
    g485E.bufAdd( type );     // typ ramki STATUS
    g485E.bufAdd( 0x0D );	  // counter
    g485E.bufAdd( 0xE0 );     // CRC
    g485E.bufAdd( 0xE1 );     // CRC

    g485E.bufAdd( status );   // Status
    g485E.bufAdd( rels2 );    // Relays

    g485E.bufAdd( mSO1 );    // Prad sens 1
    g485E.bufAdd( mSO2 );    // Prad sens 2
    g485E.bufAdd( mUA1 );     // UA linii
    g485E.bufAdd( mUA2 );     // UA linii
    g485E.bufAdd( mUB1 );     // UB linii
    g485E.bufAdd( mUB2 );     // UB linii

    g485E.bufAdd( mIA1 );     // IA linii
    g485E.bufAdd( mIA2 );     // IA linii
    g485E.bufAdd( mIB1 );     // IB linii
    g485E.bufAdd( mIB2 );     // IB linii

    g485E.bufAdd( sleepTime );// sleepTime

    g485E.Send_IT();
}// -----------------------------------------------------------


/// ----------------------------------------------------------
/// FRAME AskStatus  ToGateway
void MST7580::frameRX_ToGateway_hiFromUnreg( uint8_t *frame ){
	uint8_t addr  = frame[1];
	uint8_t gateway  = frame[2];

	if(g485E.mMyAddr != gateway) return;

    g485E.bufAdd( 0x5A );     // naglowek
    g485E.bufAdd( g485E.loopNr ); //loop
    g485E.bufAdd( gateway );     // gateway
    g485E.bufAdd( addr );     // address
    g485E.bufAdd( 0xC6 );     // typ ramki
    g485E.bufAdd( 0x00 );     // ilosc
    g485E.bufAdd( 0xE0 );     // CRC
    g485E.bufAdd( 0xE1 );     // CRC

    g485E.Send_IT();


}// -----------------------------------------------------------

/// ----------------------------------------------------------
/// FRAME EXT  ToGateway
void MST7580::frameRX_ToGateway_Ext( uint8_t *frame ){
  
    
}// -----------------------------------------------------------

void MST7580::frameRX_ToGateway_relaysSet( uint8_t *frame )
{
	uint8_t gateway  = frame[1];
	uint8_t addr  = frame[2];
	uint8_t rels = frame[3];

	if (gateway != g485E.mMyAddr)
		return;

    g485E.bufAdd( 0x5A );     // naglowek
    g485E.bufAdd( g485E.loopNr ); //loop
    g485E.bufAdd( gateway );     // gateway
    g485E.bufAdd( addr );     // address
    g485E.bufAdd( 0xC4 );     // typ ramki
    g485E.bufAdd( 0x01 );     // ilosc
    g485E.bufAdd( 0xE0 );     // CRC
    g485E.bufAdd( 0xE1 );     // CRC

    g485E.bufAdd(rels);

    g485E.Send_IT();
}

void MST7580::frameRX_ToGateway_addrSet( uint8_t *frame )
{
	uint8_t gateway  = frame[1];
	uint8_t addr  = frame[2];
	uint8_t newAddr = frame[3];

	if (gateway != g485E.mMyAddr)
		return;

	g485E.bufAdd( 0x5A );     // naglowek
	g485E.bufAdd( g485E.loopNr ); //loop
	g485E.bufAdd( gateway );     // gateway
	g485E.bufAdd( addr );     // address
	g485E.bufAdd( 0xC5 );     // typ ramki
	g485E.bufAdd( 0x01 );     // ilosc
	g485E.bufAdd( 0xE0 );     // CRC
	g485E.bufAdd( 0xE1 );     // CRC

	g485E.bufAdd(newAddr);

	g485E.Send_IT();
}

void MST7580::frameRX_ToGateway_turnOnPins( uint8_t *frame )
{
	uint8_t gateway  = frame[1];
	uint8_t addr  = frame[2];

	if (gateway != g485E.mMyAddr)
		return;

	g485E.bufAdd( 0x5A );     // naglowek
	g485E.bufAdd( g485E.loopNr ); //loop
	g485E.bufAdd( gateway );     // gateway
	g485E.bufAdd( addr );     // address
	g485E.bufAdd( 0xC8 );     // typ ramki
	g485E.bufAdd( 0x00 );     // ilosc
	g485E.bufAdd( 0xE0 );     // CRC
	g485E.bufAdd( 0xE1 );     // CRC

	g485E.Send_IT();
}

#endif
/*########################################################################################*/
