/**
******************************************************************************
* @file    ST7580_Config.h
* @author  CLAB
* @version 1.1.0
* @date    18-Sept-2017
* @brief   ST7580 Configuration and useful defines 
* 
* @details
*
* This file is used to include all or a part of the ST7580
* libraries into the application program which will be used.
* Moreover some important parameters are defined here and the
* user is allowed to edit them.
*
* @attention
*
* <h2><center>&copy; COPYRIGHT(c) 2017 STMicroelectronics</center></h2>
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*   1. Redistributions of source code must retain the above copyright notice,
*      this list of conditions and the following disclaimer.
*   2. Redistributions in binary form must reproduce the above copyright notice,
*      this list of conditions and the following disclaimer in the documentation
*      and/or other materials provided with the distribution.
*   3. Neither the name of STMicroelectronics nor the names of its contributors
*      may be used to endorse or promote products derived from this software
*      without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __ST7580_CONFIG_H
#define __ST7580_CONFIG_H


  /* Includes ------------------------------------------------------------------*/

#include "ST7580_Serial.h"
#include "e:\XCh\OneDrive_AC\Projects\ZUT\pAudio\soft\ARM\CA9\Mods\ST7580\drv\stm32_plm01a1.h"

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup ST7580_Libraries        ST7580 Libraries
 * @brief This firmware implements libraries which allow the user
 * to manage the features of ST7580 without knowing the hardware details.
 * @details The <i>ST7580_Libraries</i> modules are totally platform independent. The library provides one
 * module for each device feature.
 * @{
 */

/** @defgroup ST7580_Configuration      Configuration
 * @brief ST7580 Configuration and useful defines.
 * @details See the file <i>@ref ST7580_Config.h</i> for more details.
 * @{
 */


/** @defgroup Configuration_Exported_Types      Configuration Exported Types
 * @{
 */

/**
 * @}
 */


/** @defgroup Configuration_Exported_Constants  Configuration Exported Constants
 * @{
 */

/**
 * @}
 */


/** @defgroup Configuration_Exported_Macros     Configuration Exported Macros
 * @{
 */

/**
 * @}
 */


/** @defgroup Configuration_Exported_Functions  Configuration Exported Functions
 * @{
 */

/**
 * @}
 */

/**
 * @}
 */


/**
 * @}
 */


#ifdef __cplusplus
}
#endif

#endif

/******************* (C) COPYRIGHT 2016 STMicroelectronics *****END OF FILE****/
