/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "adc.h"
#include "dma.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

#define _M_ID     0x21070A01

#define _MODULE_ADDR    0x00	// Jaki chcemy mieć adres po wgraniu (procedura setup go zmieni).
#define _LOOP_NR		0x01	// Jaki jest to nr pętli.

//#define _AC
#define _DC




#include "../Mods/Struct/MBufCircular.h"
//
#include "../Mods/GPIO/MGPIO.h"
#include "../Mods/RS485_E/M485_E.h"     		// 485
#include "../Mods/ST7580/MST7580.h"     		// Modem
#include "../Mods/System/MSystem.h"     		// PwrSup_Source;
#include "../Mods/Relays/MRelays.h"     		// Relays init onTimer
#include "../Mods/ADC/MADC.h"           		// ADC
#include "../Mods/Network/MNetwork.h"   		// M0 M1 itp - timeouty
#include "../Mods/Flash_SSD/MFlash_SSD.h"		// Flash do zapisu adresu
#include "../Mods/PowerSaving/MPowerSaving.h"	// Do sterowania oszczędzaniem energii.

#include "../Mods/Debug/MDebug.h"			// Do mierzenia czasu - tylko do debugu.
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */


//-----------------------------------------------------------------------------
void HAL_ADC_ConvCpltCallback(ADC_HandleTypeDef* hadc)
{
      if( hadc == &hadc1 )  gADC.onSample_ADC1();
}//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
void HAL_UART_TxCpltCallback( UART_HandleTypeDef *huart ){
  //__disable_irq();
  if( huart == g485E.mhUart   )  g485E.onIT_TX();
  if( huart == gST7580.mhUart )  gST7580.onIT_TX();
 // __enable_irq();
 }//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart ) {
 // __disable_irq();
  if( huart == g485E.mhUart   )	  g485E.onIT_RX();
  if( huart == gST7580.mhUart )  gST7580.onIT_RX();
//  __enable_irq();
 }//----------------------------------------------------------------------------



void HAL_SYSTICK_Callback(void){

    // --- System ----------
   gSystem.onTimer_1ms();

    // --- ADC -----------
   gADC.onTimer_1ms();

    // --- RELAYs -----------
   gRelays.onTimer_1ms(); // zwarcie + wylaczanie przekaznikow

    // --- Oszczędzanie energii -----------
   gPowerSaving.onTimer_1ms();
}//--------------------------------------



uint8_t gWasIrq = 0;
uint8_t gPvdLvl = 0;
uint8_t gWaitForTurnOff = 0;

void HAL_PWR_PVDCallback()
{
	gWasIrq++;
}

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
   HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */
  HAL_Delay(1600);	// Opóźnienie w uruchomieniu, aby naładować kondensatory i prawidłowo uruchomić płytkę UART.
  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_ADC1_Init();
  MX_USART1_UART_Init();
  MX_USART2_UART_Init();
  /* USER CODE BEGIN 2 */
 // HAL_ADC_Start_DMA( &hadc1, (uint32_t*)gADC1Tab, 9 );


  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  // DMA1->CCR1.HTIE = 0// TEIE = 0
  //ADC1->IER &= ~ADC_ISR_OVR;

  // Ustaw pin PH3-BOOT na 0.
  HAL_GPIO_WritePin(PH3_BOOT0_GPIO_Port, PH3_BOOT0_Pin, GPIO_PIN_RESET);

  gRelays.init();
  gRelays.initProc();


  // ... PINY INIT ...............................
  HAL_GPIO_WritePin(oPLM_ON_GPIO_Port, oPLM_ON_Pin, (GPIO_PinState) 1 ); // PLM Block - Power on
  _o485E_PowEN = 0;

  gST7580.pinTREQ(1) ;
  gST7580.pinRESETN(1);

  // ... MODULY INIT ..............................
  gSystem.init();	// Address
  gADC.init();
  g485E.init( &huart1 );

  gST7580.init(&huart2);
  gST7580.initModem();

  gPowerSaving.init();



  __enable_irq();

  gADC.initIRQ();
//  gSystem.writeFlash( 0 );
  while (1)
  {


	  // ... Timer_Main 1 s ..........................
  if( gSystem.mTimer_Is1000ms ){
	  gSystem.mTimer_Is1000ms = false;
	  gST7580.onTimer_Main1000ms();

	  // --- Dodatkowe do pomiarów ----
	  if (gWaitForTurnOff >= 6) // 6s.
	  {
//		  // Wyłącz modem.
//		  HAL_GPIO_WritePin(oPLM_ON_GPIO_Port, oPLM_ON_Pin, GPIO_PIN_RESET);
//
//		  // Wyłącz czujki pożarowe.
//		  HAL_GPIO_WritePin(oSens_IsON_1_GPIO_Port, oSens_IsON_1_Pin, GPIO_PIN_RESET);
//		  HAL_GPIO_WritePin(oSens_IsON_2_GPIO_Port, oSens_IsON_2_Pin, GPIO_PIN_RESET);
//
//		  // Wyłącz układ mierzący prąd. Jest active low, więc ustawiamy na SET żeby wyłączyć.
//		  HAL_GPIO_WritePin(onCM_ON_GPIO_Port, onCM_ON_Pin, GPIO_PIN_SET);
//
//		  // Wyłącz napięcie na UART. Też jest active low.
//		  _o485E_PowEN = 1;
//
//		  // Wejdź do Sleep Mode.
//		  // HAL_SuspendTick();
//		  // HAL_PWR_EnterSLEEPMode(PWR_MAINREGULATOR_ON, PWR_SLEEPENTRY_WFI);
//
//		  // Wejdź do Stop Mode.
//		  // HAL_SuspendTick();
//		  // HAL_PWR_EnterSTOPMode(PWR_LOWPOWERREGULATOR_ON, PWR_STOPENTRY_WFI);
	  }

	  if (gWaitForTurnOff < 20)
		  gWaitForTurnOff++;
	  // ------------------------------

	 // g485E.bufAdd(0x5A);
	 // g485E.Send_IT();
	 // _oLED_B = ~_oLED_B;
  }


    // ... Timer_Main 100 ms ..........................
    if( gSystem.mTimer_Is100ms ){
      gSystem.mTimer_Is100ms = false;
      gSystem.onTimer_Main100ms();      // PwrSupSource: if all Rels OFF ->
                                        // 1.5s -> UA?UB -> SupSource
      gST7580.onTimer_Main100ms();      // puste
      //gMod1.onTimer_Main100ms();        // WDT+=1
      //g485E.sendTX_ID(0x00);
      g485E.onTimer_Main100ms();
    }


    // ... Timer_Main 10 ms ..........................
    if( gSystem.mTimer_Is10ms ){
      gSystem.mTimer_Is10ms = false;
      gRelays.onTimer_Main10ms();     // PwrSupSource
      g485E.onTimer_Main10ms();       // WDT do TimeOut


    }

    // ... Timer_Main 3 ms ..........................
    if( gSystem.mTimer_Is3ms ){
      gSystem.mTimer_Is3ms = false;
      gST7580.onTimer_Main10ms();     // Modem: czy ramka -> odbierz (1=wyslij)
    }


    gADC.onSample_ADC1();
    gPowerSaving.onMain_0ms();

    //__HAL_DMA_CLEAR_FLAG(&hdma_adc1, DMA_FLAG_TC1 | DMA_FLAG_GL1 | DMA_FLAG_HT1 ); // DMA_FLAG_TE1 ???



    // ..............................................



//	  const int cnt = 2;
//	  uint8_t frame[cnt];
//	  frame[0] = 0x50;            // cmd = ID
//	  frame[1] = 0x12;         	 // param
//	  gST7580.mBuf_Frames.bufAddFrame(cnt, frame);
//
//	  gST7580.onTimer_Main10ms();
//
//
//	  HAL_Delay(300);


    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  if (HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLM = 1;
  RCC_OscInitStruct.PLL.PLLN = 15;
  RCC_OscInitStruct.PLL.PLLQ = RCC_PLLQ_DIV2;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV4;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_3) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

//#include "../Mods/RS485_E/M485_E_cpp.h"
//#include "../Mods/RS485_E/M485_E_cpp_RX.h"
//#include "../Mods/RS485_E/M485_E_cpp_TX.h"

#include "../Mods/ST7580/MST7580_cpp.h"
#include "../Mods/ST7580/MST7580_cpp_TX.h"
#include "../Mods/ST7580/MST7580_cpp_RX.h"

#include "../Mods/RS485_E/M485_E_cpp.h"
#include "../Mods/RS485_E/M485_E_cpp_RX.h"
#include "../Mods/RS485_E/M485_E_cpp_TX.h"
#include "../Mods/Relays/MRelays_cpp.h"

#include "../Mods/ADC/MADC_cpp.h"
#include "../Mods/System/MSystem_cpp.h"
//#include "../Mods/Flash_SSD/MFlash_SSD_cpp.h"


//#include "../Mods/ST7580/MST7580_cpp_TX.h"
//#include "../Mods/ST7580/MST7580_cpp_RX.h"

#include "../Mods/PowerSaving/MPowerSaving_cpp.h"

#include "../Mods/Debug/MDebug_cpp.h"

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
